#include "rad_def.inc"

global_settings {

  // adjust the gamma here if render is too light/dark
  // 1.0 = lighter
  // 2.0 = darker
  assumed_gamma 1.5

  radiosity {
  
    // uncomment one of the lines below depending on
    // what level of render quality you want.    
  
    //Rad_Settings(Radiosity_Default, off, off)
    //Rad_Settings(Radiosity_Debug, off, off)
    //Rad_Settings(Radiosity_Fast, off, off)
    //Rad_Settings(Radiosity_Normal, off, off)
    //Rad_Settings(Radiosity_2Bounce, off, off)
    Rad_Settings(Radiosity_Final, off, off)

    //Rad_Settings(Radiosity_OutdoorLQ, off, off)
    //Rad_Settings(Radiosity_OutdoorHQ, off, off)
    //Rad_Settings(Radiosity_OutdoorLight, off, off)
    //Rad_Settings(Radiosity_IndoorLQ, off, off)
    //Rad_Settings(Radiosity_IndoorHQ, off, off)

  }
}

// set this to true if you want and extra light
// set it to false to just use ambient lighting
#declare use_light = false;

/* extra light if so desired */
#if (use_light)
  light_source {
    <0.0, 80.0, 30.0>*1000           // location of the extra light x, y, z
    color rgb <1.0, 1.0, 1.0>        // color of the extra light   
  }
#end  
  
/* Our Camera. */
camera {
  location <-30, 40, 60>         // where the camera is located x, y, z
  look_at <0.0, 25, 15>              // point that the camera is looking at x, y, z
}


/* The background - basically we're inside a huge white ball */
sphere {
  <0.0, 0.0, 0.0>, 1
  texture {
   pigment { color rgb <1.0, 1.0, 1.0> }      // colour of the background
   finish { diffuse 0.0 ambient 1.0 }
  }
  hollow on
  no_shadow
  scale 30000
}   

/* The floor, a infinitve plane along the Y axis which shadows are cast onto */
plane {
  y, 0.0
  texture {
    pigment { color rgb <1.0, 1.0, 1.0> }     // colour of the floor
    finish { diffuse 1.0 ambient 0.0 }
  }
}


/* included our model */
#include "soldier.inc"                     // file name of exported include file

object {
   milkshape_model
   translate <0, 17, 0>                    // move the model up (DoD models appear in the ground when animated) (x,y,z)
   rotate <0, 0, 0>                       // rotate the object if its orientation is wrong (x,y,z)
   scale <-1, 1, 1>                       // flip along and axis (mirror) if its back to front (happens sometimes) (x,y,z)
}        